import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/dimensions.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_images.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/url_container.dart';
import 'package:viser_remit/data/controller/account/profile_complete_controller.dart';
import 'package:viser_remit/data/repo/account/profile_repo.dart';
import 'package:viser_remit/data/services/api_client.dart';
import 'package:viser_remit/view/components/app-bar/custom_appbar.dart';
import 'package:viser_remit/view/components/buttons/rounded_button.dart';
import 'package:viser_remit/view/components/buttons/rounded_loading_button.dart';
import 'package:viser_remit/view/components/custom_loader/custom_loader.dart';
import 'package:viser_remit/view/components/image/my_image_widget.dart';
import 'package:viser_remit/view/components/text-form-field/custom_text_field.dart';
import 'package:viser_remit/view/components/text-form-field/label_text_field.dart';
import 'package:viser_remit/view/components/will_pop_widget.dart';
import 'package:viser_remit/view/screens/auth/registration/widget/country_bottom_sheet.dart';
import '../../../../core/utils/util.dart';

class ProfileCompleteScreen extends StatefulWidget {
  const ProfileCompleteScreen({Key? key}) : super(key: key);

  @override
  State<ProfileCompleteScreen> createState() => _ProfileCompleteScreenState();
}

class _ProfileCompleteScreenState extends State<ProfileCompleteScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(ProfileRepo(
      apiClient: Get.find(),
    ));
    final controller = Get.put(ProfileCompleteController(profileRepo: Get.find()));
    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.initData();
    });
  }

  @override
  void dispose() {
    super.dispose();
  }

  final formKey = GlobalKey<FormState>();

  @override
  Widget build(BuildContext context) {
    return WillPopWidget(
      nextRoute: '',
      child: Scaffold(
        backgroundColor: MyColor.getScreenBgColor(),
        appBar: CustomAppBar(
          title: MyStrings.profileComplete.tr,
          isShowBackBtn: true,
          fromAuth: false,
          isProfileCompleted: true,
          bgColor: MyColor.getAppBarColor(),
        ),
        body: GetBuilder<ProfileCompleteController>(
          builder: (controller) => controller.isLoading
              ? const CustomLoader()
              : SingleChildScrollView(
                  physics: const BouncingScrollPhysics(),
                  padding: Dimensions.screenPaddingHV,
                  child: Container(
                    padding: const EdgeInsetsDirectional.symmetric(horizontal: Dimensions.space20, vertical: Dimensions.space25),
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(Dimensions.space10),
                      color: MyColor.getCardBgColor(),
                      boxShadow: MyUtils.getCardShadow(),
                    ),
                    child: Form(
                      key: formKey,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          const SizedBox(height: Dimensions.space15),
                          //CustomImageWidget(imagePath:  '', onClicked: (){}),
                          Center(
                            child: Image.asset(
                              MyImages.appLogo,
                              height: 50,
                              width: 225,
                            ),
                          ),
                          const SizedBox(height: Dimensions.space30),
                          CustomTextField(
                            animatedLabel: true,
                            needOutlineBorder: true,
                            labelText: MyStrings.username.tr,
                            hintText: "${MyStrings.enterYour.tr} ${MyStrings.username.toLowerCase().tr}",
                            textInputType: TextInputType.text,
                            inputAction: TextInputAction.next,
                            focusNode: controller.usernameFocusNode,
                            controller: controller.usernameController,
                            nextFocus: controller.mobileNoFocusNode,
                            onChanged: (value) {
                              return;
                            },
                          ),
                          const SizedBox(height: Dimensions.space25),
                          LabelTextField(
                            outLineBorderColor: MyColor.transparentColor,
                            radius: 4,
                            fillColor: MyColor.textFieldColor,
                            onChanged: (v) {},
                            labelText: (MyStrings.phoneNo).replaceAll('.', '').tr,
                            hintText: MyStrings.enterYourPhoneNumber,
                            controller: controller.mobileNoController,
                            focusNode: controller.mobileNoFocusNode,
                            textInputType: TextInputType.phone,
                            inputAction: TextInputAction.next,
                            prefixIcon: SizedBox(
                              width: 100,
                              child: FittedBox(
                                child: Row(
                                  children: [
                                    GestureDetector(
                                      onTap: () {
                                        CountryBottomSheet.profileCompleteCountryBottomSheet(context, controller);
                                      },
                                      child: Container(
                                        padding: const EdgeInsetsDirectional.symmetric(horizontal: Dimensions.space12),
                                        decoration: BoxDecoration(
                                          color: MyColor.getTransparentColor(),
                                          borderRadius: BorderRadius.circular(5),
                                        ),
                                        alignment: Alignment.center,
                                        child: Row(
                                          children: [
                                            MyImageWidget(
                                              imageUrl: UrlContainer.countryFlagImageLink.replaceAll('{countryCode}', controller.countryCode.toString().toLowerCase()),
                                              height: Dimensions.space25,
                                              width: Dimensions.space40 + 2,
                                            ),
                                            const SizedBox(width: Dimensions.space5),
                                            Text(controller.mobileCode ?? ''),
                                            const SizedBox(width: Dimensions.space3),
                                            Icon(
                                              Icons.arrow_drop_down_rounded,
                                              color: MyColor.getIconColor(),
                                            ),
                                            Container(
                                              width: 2,
                                              height: Dimensions.space12,
                                              color: MyColor.getBorderColor(),
                                            ),
                                            const SizedBox(width: Dimensions.space8)
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          const SizedBox(height: Dimensions.space25),
                          CustomTextField(
                            animatedLabel: true,
                            needOutlineBorder: true,
                            labelText: MyStrings.address.tr,
                            hintText: "${MyStrings.enterYour.tr} ${MyStrings.address.toLowerCase().tr}",
                            textInputType: TextInputType.text,
                            inputAction: TextInputAction.next,
                            focusNode: controller.addressFocusNode,
                            controller: controller.addressController,
                            nextFocus: controller.stateFocusNode,
                            onChanged: (value) {
                              return;
                            },
                          ),
                          const SizedBox(height: Dimensions.space25),

                          CustomTextField(
                            animatedLabel: true,
                            needOutlineBorder: true,
                            labelText: MyStrings.state.tr,
                            hintText: "${MyStrings.enterYour.tr} ${MyStrings.state.toLowerCase().tr}",
                            textInputType: TextInputType.text,
                            inputAction: TextInputAction.next,
                            focusNode: controller.stateFocusNode,
                            controller: controller.stateController,
                            nextFocus: controller.cityFocusNode,
                            onChanged: (value) {
                              return;
                            },
                          ),
                          const SizedBox(height: Dimensions.space25),

                          CustomTextField(
                            animatedLabel: true,
                            needOutlineBorder: true,
                            labelText: MyStrings.city.tr,
                            hintText: "${MyStrings.enterYour.tr} ${MyStrings.city.toLowerCase().tr}",
                            textInputType: TextInputType.text,
                            inputAction: TextInputAction.next,
                            focusNode: controller.cityFocusNode,
                            controller: controller.cityController,
                            nextFocus: controller.zipCodeFocusNode,
                            onChanged: (value) {
                              return;
                            },
                          ),
                          const SizedBox(height: Dimensions.space25),

                          CustomTextField(
                            animatedLabel: true,
                            needOutlineBorder: true,
                            labelText: MyStrings.zipCode.tr,
                            hintText: "${MyStrings.enterYour.tr} ${MyStrings.zipCode.toLowerCase().tr}",
                            textInputType: TextInputType.text,
                            inputAction: TextInputAction.done,
                            focusNode: controller.zipCodeFocusNode,
                            controller: controller.zipCodeController,
                            onChanged: (value) {
                              return;
                            },
                          ),
                          const SizedBox(height: Dimensions.space35),

                          // Visibility(
                          //   visible: controller.formList.isNotEmpty && controller.type == '1',
                          //   // visible: homeController.formList.isNotEmpty,
                          //   child: ListView.builder(
                          //       shrinkWrap: true,
                          //       physics: const NeverScrollableScrollPhysics(),
                          //       scrollDirection: Axis.vertical,
                          //       itemCount: controller.formList.length,
                          //       itemBuilder: (ctx, index) {
                          //         FormModel? model = controller.formList[index];
                          //         return Padding(
                          //           padding: const EdgeInsets.all(3),
                          //           child: Column(
                          //             crossAxisAlignment: CrossAxisAlignment.start,
                          //             mainAxisSize: MainAxisSize.min,
                          //             children: [
                          //               model.type == 'text'
                          //                   ? Column(
                          //                       crossAxisAlignment: CrossAxisAlignment.start,
                          //                       children: [
                          //                         CustomTextField(
                          //                             isRequired: model.isRequired == 'optional' ? false : true,
                          //                             hintText: (model.name ?? '').toString().capitalizeFirst,
                          //                             needOutlineBorder: true,
                          //                             labelText: model.name ?? '',
                          //                             validator: (value) {
                          //                               if (model.isRequired != 'optional ' && value.toString().isEmpty) {
                          //                                 return '${model.name.toString().capitalizeFirst} ${MyStrings.isRequired}';
                          //                               } else {
                          //                                 return null;
                          //                               }
                          //                             },
                          //                             onChanged: (value) {
                          //                               controller.changeSelectedValue(value, index);
                          //                             }),
                          //                         const SizedBox(height: Dimensions.space10),
                          //                       ],
                          //                     )
                          //                   : model.type == 'textarea'
                          //                       ? Column(
                          //                           crossAxisAlignment: CrossAxisAlignment.start,
                          //                           children: [
                          //                             CustomTextField(
                          //                                 isRequired: model.isRequired == 'optional' ? false : true,
                          //                                 needOutlineBorder: true,
                          //                                 labelText: model.name ?? '',
                          //                                 hintText: (model.name ?? '').capitalizeFirst,
                          //                                 validator: (value) {
                          //                                   if (model.isRequired != 'optional ' && value.toString().isEmpty) {
                          //                                     return '${model.name.toString().capitalizeFirst} ${MyStrings.isRequired}';
                          //                                   } else {
                          //                                     return null;
                          //                                   }
                          //                                 },
                          //                                 onChanged: (value) {
                          //                                   controller.changeSelectedValue(value, index);
                          //                                 }),
                          //                             const SizedBox(height: Dimensions.space10),
                          //                           ],
                          //                         )
                          //                       : model.type == 'select'
                          //                           ? Column(
                          //                               crossAxisAlignment: CrossAxisAlignment.start,
                          //                               children: [
                          //                                 FormRow(label: model.name ?? '', isRequired: model.isRequired == 'optional' ? false : true),
                          //                                 const SizedBox(
                          //                                   height: Dimensions.textToTextSpace,
                          //                                 ),
                          //                                 CustomDropDownWithTextField(
                          //                                     list: model.options ?? [],
                          //                                     onChanged: (value) {
                          //                                       controller.changeSelectedValue(value, index);
                          //                                     },
                          //                                     selectedValue: model.selectedValue),
                          //                                 const SizedBox(height: Dimensions.space10)
                          //                               ],
                          //                             )
                          //                           : model.type == 'radio'
                          //                               ? Column(
                          //                                   crossAxisAlignment: CrossAxisAlignment.start,
                          //                                   children: [
                          //                                     FormRow(label: model.name ?? '', isRequired: model.isRequired == 'optional' ? false : true),
                          //                                     CustomRadioButton(
                          //                                       title: model.name,
                          //                                       selectedIndex: controller.formList[index].options?.indexOf(model.selectedValue ?? '') ?? 0,
                          //                                       list: model.options ?? [],
                          //                                       onChanged: (selectedIndex) {
                          //                                         controller.changeSelectedRadioBtnValue(index, selectedIndex);
                          //                                       },
                          //                                     ),
                          //                                   ],
                          //                                 )
                          //                               : model.type == 'checkbox'
                          //                                   ? Column(
                          //                                       crossAxisAlignment: CrossAxisAlignment.start,
                          //                                       children: [
                          //                                         FormRow(label: model.name ?? '', isRequired: model.isRequired == 'optional' ? false : true),
                          //                                         CustomCheckBox(
                          //                                           selectedValue: controller.formList[index].cbSelected,
                          //                                           list: model.options ?? [],
                          //                                           onChanged: (value) {
                          //                                             controller.changeSelectedCheckBoxValue(index, value);
                          //                                           },
                          //                                         ),
                          //                                       ],
                          //                                     )
                          //                                   : model.type == 'file'
                          //                                       ? Column(
                          //                                           crossAxisAlignment: CrossAxisAlignment.start,
                          //                                           children: [FormRow(label: model.name ?? '', isRequired: model.isRequired == 'optional' ? false : true), Padding(padding: const EdgeInsets.symmetric(vertical: Dimensions.textToTextSpace), child: ConfirmWithdrawFileItem(index: index))],
                          //                                         )
                          //                                       : const SizedBox(),
                          //               const SizedBox(height: Dimensions.space10),
                          //             ],
                          //           ),
                          //         );
                          //       }),
                          // ),

                          controller.submitLoading
                              ? const RoundedLoadingBtn()
                              : RoundedButton(
                                  text: MyStrings.updateProfile.tr,
                                  press: () {
                                    controller.updateProfile();
                                  },
                                )
                        ],
                      ),
                    ),
                  ),
                ),
        ),
      ),
    );
  }
}
